//Lab 03:Plot amplitude versus describing function of saturation nonlinearity.

//scilab - 6.0.0
// Operating System : Windows 10, 64-bit

//------------------------------------------------------------------
close;
clc;
clear;
//------------------------------------------------------------------

//Response of the saturation nonlinearity to sinusoidal input
figure;
importXcosDiagram(".\Lab03_DF_Saturation_Model.xcos")
xcos_simulate(scs_m,4);
scs_m.props.context
plot(yt.time,yt.values(:,1),'r--','thickness',2)
plot(yt.time,yt.values(:,2),'b','thickness',2)
xlabel('Time (sec.)','fontsize',2);
ylabel('Amplitude','fontsize',2);
xset('font size',2);
title("Saturation nonlinearity output to sinusoidal input",'fontsize',4);
exec .\figure_properties.sci; //custom script for setting figure properties
//------------------------------------------------------------------
//Describing Functin for saturation nonlinearity.
k=1;
N=1;
i=1;
Keq=[];

for a=0:0.2:10
    if k*a/N > 1 then
    Keq(i,1)=2/%pi*(k*asin(N/a/k)+N/a*sqrt(1-(N/k/a)^2))
    else
    Keq(i,1)=k
    end
    i=i+1;
end

a=0:0.2:10;
a=a';
figure,
plot(a,Keq,'thickness',2)
xlabel('$a$','fontsize',2);
ylabel('$K_{eq}$','fontsize',2);

xset('font size',2);
title("Describing Function for a saturation nonlinearity with k=N=1",'fontsize',4);
exec .\figure_properties.sci; //custom script for setting figure properties
zoom_rect([0 0 10 1.1])
//------------------------------------------------------------------
